/*
 * *****************************************************************
 * *                                                               *
 * *    Copyright (c) Digital Equipment Corporation, 1991, 1996    *
 * *                                                               *
 * *   All Rights Reserved.  Unpublished rights  reserved  under   *
 * *   the copyright laws of the United States.                    *
 * *                                                               *
 * *   The software contained on this media  is  proprietary  to   *
 * *   and  embodies  the  confidential  technology  of  Digital   *
 * *   Equipment Corporation.  Possession, use,  duplication  or   *
 * *   dissemination of the software and media is authorized only  *
 * *   pursuant to a valid written license from Digital Equipment  *
 * *   Corporation.                                                *
 * *                                                               *
 * *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
 * *   by the U.S. Government is subject to restrictions  as  set  *
 * *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
 * *   or  in  FAR 52.227-19, as applicable.                       *
 * *                                                               *
 * *****************************************************************
 */
/*
 * HISTORY
 */

/* A lexical scanner generated by flex */

/* scanner skeleton version:
 * @(#)$RCSfile: flex.skel,v $ $Revision: 1.1.6.2 $ (DEC) $Date: 1995/06/05 20:09:02 $
 */

#define FLEX_SCANNER

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

#define YY_USE_PROTOS

/* the "const" storage-class-modifier is valid */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#ifdef __STDC__

#include <stdlib.h>

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#if defined (YY_USE_PROTOS)
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif


/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */

/* this used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite()
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#define YY_INPUT(buf,result,max_size) \
	if ( (result = read( fileno(yyin), (char *) buf, max_size )) < 0 ) \
	    YY_FATAL_ERROR( "read() in flex scanner failed" );
#define YY_NULL 0

/* no semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#define yyterminate() return ( YY_NULL )

/* report a fatal error */

/* The funky do-while is used to turn this macro definition into
 * a single C statement (which needs a semi-colon terminator).
 * This avoids problems with code like:
 *
 * 	if ( something_happens )
 *		YY_FATAL_ERROR( "oops, the something happened" );
 *	else
 *		everything_okay();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the YY_FATAL_ERROR() call.
 */

#define YY_FATAL_ERROR(msg) \
	do \
		{ \
		(void) fputs( msg, stderr ); \
		(void) putc( '\n', stderr ); \
		exit( 1 ); \
		} \
	while ( 0 )

/* default yywrap function - always treat EOF as an EOF */
#define yywrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN yy_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE \
	do \
		{ \
		yy_init_buffer( yy_current_buffer, yyin ); \
		yy_load_buffer_state(); \
		} \
	while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define YY_DECL int yylex YY_PROTO(( void )) 

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct yy_buffer_state *YY_BUFFER_STATE;

#define YY_CHAR unsigned char
# line 1 "lex.l"
#define INITIAL 0
# line 2 "lex.l"

#include "token.h"
#include "util.h"

#ifdef __unix__
#include <unistd.h>
#else
#include <io.h>
#endif

#define yywrap() 1
#define YY_SKIP_YYWRAP 1

// Some static data definition

static char *file_name;                  
static int line, pos;    // Token position
extern char *i_path;

struct scan_state { 
    int             pos;
    int             line;
    char*           file_name;
    char*           search_path; 
    FILE*           input;
    YY_BUFFER_STATE buffer; 
};

#define MAX_INCLUDE_DEPTH 64   // Include stack depth

class scan_ctx { 
  protected: 
    scan_state      stack[ MAX_INCLUDE_DEPTH ];
    int             sp;

  public:
    void push();
    void attach(char* name, FILE* in);
    void pop(); 
    bool empty() { return sp == 0; }
    bool find(char* name) ; 
    scan_ctx() { sp = 0; }
};
    
static scan_ctx scanner; 

void scanner_input(char *file) 
{
    FILE* f = fopen (file, "r");
	
    if (f == NULL) { 
	error("can't open input source file: %s", file); 
    }
    scanner.attach(file, f);
}



// Hints for macro functionality (inherited from rtl2c)
static nm_entry *nm = NULL;	       // Token name
static char *text   = NULL;            // Token text if != NULL

#undef  ECHO
#define ECHO 

// Token generator function

int tkn (int tag) {
   curr_token = new token(text ? text : strdup(yytext),
			  tag, line, pos, nm);
   nm = NULL; text = NULL;
   for (char *c = yytext; *c != 0; c++) {
       if (*c == '\n') { line++; pos = 0; }
       else if (*c == '\t') { pos += TAB_WIDTH - (pos % TAB_WIDTH); }
       else pos++;
   }
   curr_token->fname = file_name; 
   return 1;
}



// Include file name processing

static char *include_name (char *src) {
    char *t;
    char *name = new char[strlen(src)+8]; 
    char *dst = name;
    if (strchr(src, '\n') != NULL) { 
        line += 1;
        pos = 0;
    }
    while (*src == '\'' || isspace(*src)) src++;        // Skip leading '[ ]
    if ((t = strchr (src, '[')) != NULL) {
#if 0
        int gid, uid, n;
        if (sscanf(t, "[%d,%d]%n", &gid, &uid, &n) == 2) { 
            dst += sprintf(dst, "../%03d%03d/", gid, uid);
	    src = t + n;
        } 
	else 
#endif
	{ 
	    if ((t = strrchr(src, ']')) != NULL) { 
	        src = t+1;
            }
        }
    }	   
    bool suffix = FALSE;
    while(*src && !isspace(*src) && *src != ';' && *src != '\'' && *src!='\n')
    {
        if (*src == '.') suffix = TRUE;
	*dst++ = tolower(*src++); 
    } 
    *dst = 0;
    if (!suffix) strcpy(dst, ".pas");
 
    if (scanner.find(name)) {
	error(line, pos, file_name, "file %s already included !\n", name); 
    }
    return name; 
}

static int yyinput(void);

inline int yyinput_file() { 
    int ch = yyinput(); 
    if (ch == '\n') { line++; pos = 0; }
    else if (ch == '\t') { pos += TAB_WIDTH - (pos % TAB_WIDTH); }
    else pos++;
    return ch;
}     

static int process_comments() { 
    static int cmt_buf_len = 256;
    static char* cmt_buf = new char[cmt_buf_len];
    int c, pc = 0;
    char *p = cmt_buf;
    char cmt_start = *yytext;
    *p++ = '/';
    *p++ = '*';

    curr_token = new token(NULL, TKN_CMNT, line, pos);

    pos += strlen(yytext);

    while( (c = yyinput_file()) != EOF ) {  
	if (c == '*' && cmt_start == '{') continue;
        cmt_start = 0;
        if (c == '/' && pc == '*') c = ' ';  
	if (p == cmt_buf + cmt_buf_len) {
	    cmt_buf = (char*)realloc(cmt_buf, 2*cmt_buf_len);
	    p = cmt_buf + cmt_buf_len;
	    cmt_buf_len *= 2;
	}
	if (c == '}' || (c == ')' && pc == '*')) { 
	    size_t len = p - cmt_buf;
	    text = new char[len + 3];
	    memcpy(text, cmt_buf, len);      
            if (pc != '*') text[len++] = '*';
	    text[len++] = '/';
	    text[len] = '\0';
	    curr_token->in_text = curr_token->out_text = text;
	    text = NULL;
	    return 1;
	} 
	*p++ = pc = c;
    }
    error(line, pos, file_name, "EOF in comment !\n");
    return -1;
}

/* the "incl" state is used for picking up the name
 * of an include file
 */
#define incl 1
# line 198 "lex.l"

/* done after the current pattern has been matched and before the
 * corresponding action - sets up yytext
 */
#define YY_DO_BEFORE_ACTION \
	yytext = (char *) yy_bp; \
	yyleng = yy_cp - yy_bp; \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define yyless(n) \
	do \
		{ \
		/* undo effects of setting up yytext */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (unsigned char *)yytext )


struct yy_buffer_state
    {
    FILE *yy_input_file;

    YY_CHAR *yy_ch_buf;		/* input buffer */
    YY_CHAR *yy_buf_pos;	/* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters*/
    int yy_buf_size;	

    /* number of characters read into yy_ch_buf, not including EOB characters */
    int yy_n_chars;

    int yy_eof_status;		/* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
    };

static YY_BUFFER_STATE yy_current_buffer;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed */
static YY_CHAR yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */



#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_USER_INIT
#define YY_USER_INIT
#endif

extern char *yytext;
extern int yyleng;
extern FILE *yyin, *yyout;

char *yytext;
int yyleng;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

#define YY_END_OF_BUFFER 40
struct yy_trans_info
    {
    short yy_verify;
    short yy_nxt;
    };
typedef const struct yy_trans_info *yy_state_type;
static const struct yy_trans_info yy_transition[3786] =
    {
      0, 1073885784,      0,  3530,      0,     0,      0,  3528,      1,  1032,
      2,  1032,      3,  1032,      4,  1032,      5,  1032,      6,  1032,
      7,  1032,      8,  1032,      9,  1034,     10,  1036,     11,  1032,
     12,  1034,     13,  1032,     14,  1032,     15,  1032,     16,  1032,
     17,  1032,     18,  1032,     19,  1032,     20,  1032,     21,  1032,
     22,  1032,     23,  1032,     24,  1032,     25,  1032,     26,  1032,
     27,  1032,     28,  1032,     29,  1032,     30,  1032,     31,  1032,
     32,  1034,     33,  1032,     34,  1032,     35,  1032,     36,  1038,
     37,  1056,     38,  1032,     39,  1163,     40,  1421,     41,  1423,
     42,  1425,     43,  1427,     44,  1429,     45,  1431,     46,  1433,

     47,  1435,     48,  1437,     49,  1437,     50,  1437,     51,  1437,
     52,  1437,     53,  1437,     54,  1437,     55,  1437,     56,  1437,
     57,  1437,     58,  1439,     59,  1441,     60,  1443,     61,  1445,
     62,  1447,     63,  1032,     64,  1449,     65,  1038,     66,  1038,
     67,  1038,     68,  1038,     69,  1038,     70,  1038,     71,  1038,
     72,  1038,     73,  1038,     74,  1038,     75,  1038,     76,  1038,
     77,  1038,     78,  1038,     79,  1038,     80,  1038,     81,  1038,
     82,  1038,     83,  1038,     84,  1038,     85,  1038,     86,  1038,
     87,  1038,     88,  1038,     89,  1038,     90,  1038,     91,  1451,
     92,  1032,     93,  1453,     94,  1455,     95,  1038,     96,  1032,

     97,  1038,     98,  1038,     99,  1038,    100,  1038,    101,  1038,
    102,  1038,    103,  1038,    104,  1038,    105,  1038,    106,  1038,
    107,  1038,    108,  1038,    109,  1038,    110,  1038,    111,  1038,
    112,  1038,    113,  1038,    114,  1038,    115,  1038,    116,  1038,
    117,  1038,    118,  1038,    119,  1038,    120,  1038,    121,  1038,
    122,  1038,    123,  1457,    124,  1032,    125,  1032,    126,  1032,
    127,  1032,    128,  1032,    129,  1032,    130,  1032,    131,  1032,
    132,  1032,    133,  1032,    134,  1032,    135,  1032,    136,  1032,
    137,  1032,    138,  1032,    139,  1032,    140,  1032,    141,  1032,
    142,  1032,    143,  1032,    144,  1032,    145,  1032,    146,  1032,

    147,  1032,    148,  1032,    149,  1032,    150,  1032,    151,  1032,
    152,  1032,    153,  1032,    154,  1032,    155,  1032,    156,  1032,
    157,  1032,    158,  1032,    159,  1032,    160,  1032,    161,  1032,
    162,  1032,    163,  1032,    164,  1032,    165,  1032,    166,  1032,
    167,  1032,    168,  1032,    169,  1032,    170,  1032,    171,  1032,
    172,  1032,    173,  1032,    174,  1032,    175,  1032,    176,  1032,
    177,  1032,    178,  1032,    179,  1032,    180,  1032,    181,  1032,
    182,  1032,    183,  1032,    184,  1032,    185,  1032,    186,  1032,
    187,  1032,    188,  1032,    189,  1032,    190,  1032,    191,  1032,
    192,  1032,    193,  1032,    194,  1032,    195,  1032,    196,  1032,

    197,  1032,    198,  1032,    199,  1032,    200,  1032,    201,  1032,
    202,  1032,    203,  1032,    204,  1032,    205,  1032,    206,  1032,
    207,  1032,    208,  1032,    209,  1032,    210,  1032,    211,  1032,
    212,  1032,    213,  1032,    214,  1032,    215,  1032,    216,  1032,
    217,  1032,    218,  1032,    219,  1032,    220,  1032,    221,  1032,
    222,  1032,    223,  1032,    224,  1032,    225,  1032,    226,  1032,
    227,  1032,    228,  1032,    229,  1032,    230,  1032,    231,  1032,
    232,  1032,    233,  1032,    234,  1032,    235,  1032,    236,  1032,
    237,  1032,    238,  1032,    239,  1032,    240,  1032,    241,  1032,
    242,  1032,    243,  1032,    244,  1032,    245,  1032,    246,  1032,

    247,  1032,    248,  1032,    249,  1032,    250,  1032,    251,  1032,
    252,  1032,    253,  1032,    254,  1032,    255,  1032,    256,  1032,
      0,     0,      0,  3270,      1,   774,      2,   774,      3,   774,
      4,   774,      5,   774,      6,   774,      7,   774,      8,   774,
      9,   776,     10,   778,     11,   774,     12,   776,     13,   774,
     14,   774,     15,   774,     16,   774,     17,   774,     18,   774,
     19,   774,     20,   774,     21,   774,     22,   774,     23,   774,
     24,   774,     25,   774,     26,   774,     27,   774,     28,   774,
     29,   774,     30,   774,     31,   774,     32,   776,     33,   774,
     34,   774,     35,   774,     36,   780,     37,   798,     38,   774,

     39,   905,     40,  1163,     41,  1165,     42,  1167,     43,  1169,
     44,  1171,     45,  1173,     46,  1175,     47,  1177,     48,  1179,
     49,  1179,     50,  1179,     51,  1179,     52,  1179,     53,  1179,
     54,  1179,     55,  1179,     56,  1179,     57,  1179,     58,  1181,
     59,  1183,     60,  1185,     61,  1187,     62,  1189,     63,   774,
     64,  1191,     65,   780,     66,   780,     67,   780,     68,   780,
     69,   780,     70,   780,     71,   780,     72,   780,     73,   780,
     74,   780,     75,   780,     76,   780,     77,   780,     78,   780,
     79,   780,     80,   780,     81,   780,     82,   780,     83,   780,
     84,   780,     85,   780,     86,   780,     87,   780,     88,   780,

     89,   780,     90,   780,     91,  1193,     92,   774,     93,  1195,
     94,  1197,     95,   780,     96,   774,     97,   780,     98,   780,
     99,   780,    100,   780,    101,   780,    102,   780,    103,   780,
    104,   780,    105,   780,    106,   780,    107,   780,    108,   780,
    109,   780,    110,   780,    111,   780,    112,   780,    113,   780,
    114,   780,    115,   780,    116,   780,    117,   780,    118,   780,
    119,   780,    120,   780,    121,   780,    122,   780,    123,  1199,
    124,   774,    125,   774,    126,   774,    127,   774,    128,   774,
    129,   774,    130,   774,    131,   774,    132,   774,    133,   774,
    134,   774,    135,   774,    136,   774,    137,   774,    138,   774,

    139,   774,    140,   774,    141,   774,    142,   774,    143,   774,
    144,   774,    145,   774,    146,   774,    147,   774,    148,   774,
    149,   774,    150,   774,    151,   774,    152,   774,    153,   774,
    154,   774,    155,   774,    156,   774,    157,   774,    158,   774,
    159,   774,    160,   774,    161,   774,    162,   774,    163,   774,
    164,   774,    165,   774,    166,   774,    167,   774,    168,   774,
    169,   774,    170,   774,    171,   774,    172,   774,    173,   774,
    174,   774,    175,   774,    176,   774,    177,   774,    178,   774,
    179,   774,    180,   774,    181,   774,    182,   774,    183,   774,
    184,   774,    185,   774,    186,   774,    187,   774,    188,   774,

    189,   774,    190,   774,    191,   774,    192,   774,    193,   774,
    194,   774,    195,   774,    196,   774,    197,   774,    198,   774,
    199,   774,    200,   774,    201,   774,    202,   774,    203,   774,
    204,   774,    205,   774,    206,   774,    207,   774,    208,   774,
    209,   774,    210,   774,    211,   774,    212,   774,    213,   774,
    214,   774,    215,   774,    216,   774,    217,   774,    218,   774,
    219,   774,    220,   774,    221,   774,    222,   774,    223,   774,
    224,   774,    225,   774,    226,   774,    227,   774,    228,   774,
    229,   774,    230,   774,    231,   774,    232,   774,    233,   774,
    234,   774,    235,   774,    236,   774,    237,   774,    238,   774,

    239,   774,    240,   774,    241,   774,    242,   774,    243,   774,
    244,   774,    245,   774,    246,   774,    247,   774,    248,   774,
    249,   774,    250,   774,    251,   774,    252,   774,    253,   774,
    254,   774,    255,   774,    256,   774,      0,     2,      0,  3012,
      1,  1024,      2,  1024,      3,  1024,      4,  1024,      5,  1024,
      6,  1024,      7,  1024,      8,  1024,      9,  1282,     10,   950,
     11,  1024,     12,  1024,     13,  1024,     14,  1024,     15,  1024,
     16,  1024,     17,  1024,     18,  1024,     19,  1024,     20,  1024,
     21,  1024,     22,  1024,     23,  1024,     24,  1024,     25,  1024,
     26,  1024,     27,  1024,     28,  1024,     29,  1024,     30,  1024,

     31,  1024,     32,  1282,     33,  1024,     34,  1024,     35,  1024,
     36,  1024,     37,  1024,     38,  1024,     39,  1024,     40,  1024,
     41,  1024,     42,  1024,     43,  1024,     44,  1024,     45,  1024,
     46,  1024,     47,  1024,     48,  1024,     49,  1024,     50,  1024,
     51,  1024,     52,  1024,     53,  1024,     54,  1024,     55,  1024,
     56,  1024,     57,  1024,     58,  1024,     59,   953,     60,  1024,
     61,  1024,     62,  1024,     63,  1024,     64,  1024,     65,  1024,
     66,  1024,     67,  1024,     68,  1024,     69,  1024,     70,  1024,
     71,  1024,     72,  1024,     73,  1024,     74,  1024,     75,  1024,
     76,  1024,     77,  1024,     78,  1024,     79,  1024,     80,  1024,

     81,  1024,     82,  1024,     83,  1024,     84,  1024,     85,  1024,
     86,  1024,     87,  1024,     88,  1024,     89,  1024,     90,  1024,
     91,  1024,     92,  1024,     93,  1024,     94,  1024,     95,  1024,
     96,  1024,     97,  1024,     98,  1024,     99,  1024,    100,  1024,
    101,  1024,    102,  1024,    103,  1024,    104,  1024,    105,  1024,
    106,  1024,    107,  1024,    108,  1024,    109,  1024,    110,  1024,
    111,  1024,    112,  1024,    113,  1024,    114,  1024,    115,  1024,
    116,  1024,    117,  1024,    118,  1024,    119,  1024,    120,  1024,
    121,  1024,    122,  1024,    123,  1024,    124,  1024,    125,  1024,
    126,  1024,    127,  1024,    128,  1024,    129,  1024,    130,  1024,

    131,  1024,    132,  1024,    133,  1024,    134,  1024,    135,  1024,
    136,  1024,    137,  1024,    138,  1024,    139,  1024,    140,  1024,
    141,  1024,    142,  1024,    143,  1024,    144,  1024,    145,  1024,
    146,  1024,    147,  1024,    148,  1024,    149,  1024,    150,  1024,
    151,  1024,    152,  1024,    153,  1024,    154,  1024,    155,  1024,
    156,  1024,    157,  1024,    158,  1024,    159,  1024,    160,  1024,
    161,  1024,    162,  1024,    163,  1024,    164,  1024,    165,  1024,
    166,  1024,    167,  1024,    168,  1024,    169,  1024,    170,  1024,
    171,  1024,    172,  1024,    173,  1024,    174,  1024,    175,  1024,
    176,  1024,    177,  1024,    178,  1024,    179,  1024,    180,  1024,

    181,  1024,    182,  1024,    183,  1024,    184,  1024,    185,  1024,
    186,  1024,    187,  1024,    188,  1024,    189,  1024,    190,  1024,
    191,  1024,    192,  1024,    193,  1024,    194,  1024,    195,  1024,
    196,  1024,    197,  1024,    198,  1024,    199,  1024,    200,  1024,
    201,  1024,    202,  1024,    203,  1024,    204,  1024,    205,  1024,
    206,  1024,    207,  1024,    208,  1024,    209,  1024,    210,  1024,
    211,  1024,    212,  1024,    213,  1024,    214,  1024,    215,  1024,
    216,  1024,    217,  1024,    218,  1024,    219,  1024,    220,  1024,
    221,  1024,    222,  1024,    223,  1024,    224,  1024,    225,  1024,
    226,  1024,    227,  1024,    228,  1024,    229,  1024,    230,  1024,

    231,  1024,    232,  1024,    233,  1024,    234,  1024,    235,  1024,
    236,  1024,    237,  1024,    238,  1024,    239,  1024,    240,  1024,
    241,  1024,    242,  1024,    243,  1024,    244,  1024,    245,  1024,
    246,  1024,    247,  1024,    248,  1024,    249,  1024,    250,  1024,
    251,  1024,    252,  1024,    253,  1024,    254,  1024,    255,  1024,
    256,  1024,      0,     2,      0,  2754,      1,   766,      2,   766,
      3,   766,      4,   766,      5,   766,      6,   766,      7,   766,
      8,   766,      9,  1024,     10,   692,     11,   766,     12,   766,
     13,   766,     14,   766,     15,   766,     16,   766,     17,   766,
     18,   766,     19,   766,     20,   766,     21,   766,     22,   766,

     23,   766,     24,   766,     25,   766,     26,   766,     27,   766,
     28,   766,     29,   766,     30,   766,     31,   766,     32,  1024,
     33,   766,     34,   766,     35,   766,     36,   766,     37,   766,
     38,   766,     39,   766,     40,   766,     41,   766,     42,   766,
     43,   766,     44,   766,     45,   766,     46,   766,     47,   766,
     48,   766,     49,   766,     50,   766,     51,   766,     52,   766,
     53,   766,     54,   766,     55,   766,     56,   766,     57,   766,
     58,   766,     59,   695,     60,   766,     61,   766,     62,   766,
     63,   766,     64,   766,     65,   766,     66,   766,     67,   766,
     68,   766,     69,   766,     70,   766,     71,   766,     72,   766,

     73,   766,     74,   766,     75,   766,     76,   766,     77,   766,
     78,   766,     79,   766,     80,   766,     81,   766,     82,   766,
     83,   766,     84,   766,     85,   766,     86,   766,     87,   766,
     88,   766,     89,   766,     90,   766,     91,   766,     92,   766,
     93,   766,     94,   766,     95,   766,     96,   766,     97,   766,
     98,   766,     99,   766,    100,   766,    101,   766,    102,   766,
    103,   766,    104,   766,    105,   766,    106,   766,    107,   766,
    108,   766,    109,   766,    110,   766,    111,   766,    112,   766,
    113,   766,    114,   766,    115,   766,    116,   766,    117,   766,
    118,   766,    119,   766,    120,   766,    121,   766,    122,   766,

    123,   766,    124,   766,    125,   766,    126,   766,    127,   766,
    128,   766,    129,   766,    130,   766,    131,   766,    132,   766,
    133,   766,    134,   766,    135,   766,    136,   766,    137,   766,
    138,   766,    139,   766,    140,   766,    141,   766,    142,   766,
    143,   766,    144,   766,    145,   766,    146,   766,    147,   766,
    148,   766,    149,   766,    150,   766,    151,   766,    152,   766,
    153,   766,    154,   766,    155,   766,    156,   766,    157,   766,
    158,   766,    159,   766,    160,   766,    161,   766,    162,   766,
    163,   766,    164,   766,    165,   766,    166,   766,    167,   766,
    168,   766,    169,   766,    170,   766,    171,   766,    172,   766,

    173,   766,    174,   766,    175,   766,    176,   766,    177,   766,
    178,   766,    179,   766,    180,   766,    181,   766,    182,   766,
    183,   766,    184,   766,    185,   766,    186,   766,    187,   766,
    188,   766,    189,   766,    190,   766,    191,   766,    192,   766,
    193,   766,    194,   766,    195,   766,    196,   766,    197,   766,
    198,   766,    199,   766,    200,   766,    201,   766,    202,   766,
    203,   766,    204,   766,    205,   766,    206,   766,    207,   766,
    208,   766,    209,   766,    210,   766,    211,   766,    212,   766,
    213,   766,    214,   766,    215,   766,    216,   766,    217,   766,
    218,   766,    219,   766,    220,   766,    221,   766,    222,   766,

    223,   766,    224,   766,    225,   766,    226,   766,    227,   766,
    228,   766,    229,   766,    230,   766,    231,   766,    232,   766,
    233,   766,    234,   766,    235,   766,    236,   766,    237,   766,
    238,   766,    239,   766,    240,   766,    241,   766,    242,   766,
    243,   766,    244,   766,    245,   766,    246,   766,    247,   766,
    248,   766,    249,   766,    250,   766,    251,   766,    252,   766,
    253,   766,    254,   766,    255,   766,    256,   766,      0,    38,
      0,  2496,      0,    36,      0,  2494,      0,    37,      0,  2492,
      0,    34,      0,  2490,      0,     0,      0,     0,      0,     0,
      0,     0,      9,   468,      0,     0,      0,     0,     12,   468,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,    38,      0,  2472,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,     32,   468,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,     36,  1018,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,     48,  1018,
     49,  1018,     50,  1018,     51,  1018,     52,  1018,     53,  1018,
     54,  1018,     55,  1018,     56,  1018,     57,  1018,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,     65,  1018,     66,  1018,     67,  1018,     68,  1018,
     69,  1018,     70,  1018,     71,  1018,     72,  1018,     73,  1018,
     74,  1018,     75,  1018,     76,  1018,     77,  1018,     78,  1018,
     79,  1018,     80,  1018,     81,  1018,     82,  1018,     83,  1018,
     84,  1018,     85,  1018,     86,  1018,     87,  1018,     88,  1018,
     89,  1018,     90,  1018,     73,  1013,      0,     0,      0,     0,
      0,     0,     95,  1018,      0,     0,     97,  1018,     98,  1018,
     99,  1018,    100,  1018,    101,  1018,    102,  1018,    103,  1018,
    104,  1018,    105,  1018,    106,  1018,    107,  1018,    108,  1018,

    109,  1018,    110,  1018,    111,  1018,    112,  1018,    113,  1018,
    114,  1018,    115,  1018,    116,  1018,    117,  1018,    118,  1018,
    119,  1018,    120,  1018,    121,  1018,    122,  1018,    105,  1013,
      0,    38,      0,  2365,      1,  1018,      2,  1018,      3,  1018,
      4,  1018,      5,  1018,      6,  1018,      7,  1018,      8,  1018,
      9,  1018,     10,  1018,     11,  1018,     12,  1018,     13,  1018,
     14,  1018,     15,  1018,     16,  1018,     17,  1018,     18,  1018,
     19,  1018,     20,  1018,     21,  1018,     22,  1018,     23,  1018,
     24,  1018,     25,  1018,     26,  1018,     27,  1018,     28,  1018,
     29,  1018,     30,  1018,     31,  1018,     32,  1018,     33,  1018,

     34,  1018,     35,  1018,     36,  1018,     37,  1018,     38,  1018,
     39,   912,     40,  1018,     41,  1018,     42,  1018,     43,  1018,
     44,  1018,     45,  1018,     46,  1018,     47,  1018,     48,  1018,
     49,  1018,     50,  1018,     51,  1018,     52,  1018,     53,  1018,
     54,  1018,     55,  1018,     56,  1018,     57,  1018,     58,  1018,
     59,  1018,     60,  1018,     61,  1018,     62,  1018,     63,  1018,
     64,  1018,     65,  1018,     66,  1018,     67,  1018,     68,  1018,
     69,  1018,     70,  1018,     71,  1018,     72,  1018,     73,  1018,
     74,  1018,     75,  1018,     76,  1018,     77,  1018,     78,  1018,
     79,  1018,     80,  1018,     81,  1018,     82,  1018,     83,  1018,

     84,  1018,     85,  1018,     86,  1018,     87,  1018,     88,  1018,
     89,  1018,     90,  1018,     91,  1018,     92,  1018,     93,  1018,
     94,  1018,     95,  1018,     96,  1018,     97,  1018,     98,  1018,
     99,  1018,    100,  1018,    101,  1018,    102,  1018,    103,  1018,
    104,  1018,    105,  1018,    106,  1018,    107,  1018,    108,  1018,
    109,  1018,    110,  1018,    111,  1018,    112,  1018,    113,  1018,
    114,  1018,    115,  1018,    116,  1018,    117,  1018,    118,  1018,
    119,  1018,    120,  1018,    121,  1018,    122,  1018,    123,  1018,
    124,  1018,    125,  1018,    126,  1018,    127,  1018,    128,  1018,
    129,  1018,    130,  1018,    131,  1018,    132,  1018,    133,  1018,

    134,  1018,    135,  1018,    136,  1018,    137,  1018,    138,  1018,
    139,  1018,    140,  1018,    141,  1018,    142,  1018,    143,  1018,
    144,  1018,    145,  1018,    146,  1018,    147,  1018,    148,  1018,
    149,  1018,    150,  1018,    151,  1018,    152,  1018,    153,  1018,
    154,  1018,    155,  1018,    156,  1018,    157,  1018,    158,  1018,
    159,  1018,    160,  1018,    161,  1018,    162,  1018,    163,  1018,
    164,  1018,    165,  1018,    166,  1018,    167,  1018,    168,  1018,
    169,  1018,    170,  1018,    171,  1018,    172,  1018,    173,  1018,
    174,  1018,    175,  1018,    176,  1018,    177,  1018,    178,  1018,
    179,  1018,    180,  1018,    181,  1018,    182,  1018,    183,  1018,

    184,  1018,    185,  1018,    186,  1018,    187,  1018,    188,  1018,
    189,  1018,    190,  1018,    191,  1018,    192,  1018,    193,  1018,
    194,  1018,    195,  1018,    196,  1018,    197,  1018,    198,  1018,
    199,  1018,    200,  1018,    201,  1018,    202,  1018,    203,  1018,
    204,  1018,    205,  1018,    206,  1018,    207,  1018,    208,  1018,
    209,  1018,    210,  1018,    211,  1018,    212,  1018,    213,  1018,
    214,  1018,    215,  1018,    216,  1018,    217,  1018,    218,  1018,
    219,  1018,    220,  1018,    221,  1018,    222,  1018,    223,  1018,
    224,  1018,    225,  1018,    226,  1018,    227,  1018,    228,  1018,
    229,  1018,    230,  1018,    231,  1018,    232,  1018,    233,  1018,

    234,  1018,    235,  1018,    236,  1018,    237,  1018,    238,  1018,
    239,  1018,    240,  1018,    241,  1018,    242,  1018,    243,  1018,
    244,  1018,    245,  1018,    246,  1018,    247,  1018,    248,  1018,
    249,  1018,    250,  1018,    251,  1018,    252,  1018,    253,  1018,
    254,  1018,    255,  1018,    256,  1018,      0,     8,      0,  2107,
      0,     9,      0,  2105,      0,    14,      0,  2103,      0,    15,
      0,  2101,      0,    17,      0,  2099,      0,    16,      0,  2097,
      0,    18,      0,  2095,      0,    20,      0,  2093,      0,    33,
      0,  2091,      0,    24,      0,  2089,      0,    25,      0,  2087,
      0,    28,      0,  2085,      0,    30,      0,  2083,      0,    29,

      0,  2081,      0,    21,      0,  2079,      0,    12,      0,  2077,
      0,    13,      0,  2075,      0,    22,      0,  2073,      0,     7,
      0,  2071,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,     42,   656,      0,     0,      0,     2,      0,  2062,
     46,   658,      0,     4,      0,  2059,      0,     0,      0,     0,
     35,  1002,      0,     0,     41,   648,      9,   977,     10,   977,
      0,     0,      0,     0,     46,   650,      0,     0,      0,     0,
      0,     0,     46,  1025,      0,     0,     48,  1061,     49,  1061,
     50,  1061,     51,  1061,     52,  1061,     53,  1061,     54,  1061,
     55,  1061,     56,  1061,     57,  1061,      0,     0,      0,     0,

      0,     0,     32,   977,      0,     0,     61,   648,      0,    36,
      0,  2026,     66,   648,     61,   646,     62,   648,     69,  1086,
      0,     0,     61,   647,      0,     0,      0,     0,      9,     0,
      0,     0,      0,     0,     12,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,     32,     0,     98,   648,      0,     0,
      0,     0,    101,  1086,      0,     3,      0,  1988,      1,  1061,
      2,  1061,      3,  1061,      4,  1061,      5,  1061,      6,  1061,

      7,  1061,      8,  1061,      9,  1061,      0,     0,     11,  1061,
     12,  1061,     13,  1061,     14,  1061,     15,  1061,     16,  1061,
     17,  1061,     18,  1061,     19,  1061,     20,  1061,     21,  1061,
     22,  1061,     23,  1061,     24,  1061,     25,  1061,     26,  1061,
     27,  1061,     28,  1061,     29,  1061,     30,  1061,     31,  1061,
     32,  1061,     33,  1061,     34,  1061,     35,  1061,     36,  1061,
     37,  1061,     38,  1061,     39,  1061,     40,  1061,     41,  1061,
     42,  1061,     43,  1061,     44,  1061,     45,  1061,     46,  1061,
     47,  1061,     48,  1061,     49,  1061,     50,  1061,     51,  1061,
     52,  1061,     53,  1061,     54,  1061,     55,  1061,     56,  1061,

     57,  1061,     58,  1061,     59,   901,     60,  1061,     61,  1061,
     62,  1061,     63,  1061,     64,  1061,     65,  1061,     66,  1061,
     67,  1061,     68,  1061,     69,  1061,     70,  1061,     71,  1061,
     72,  1061,     73,  1061,     74,  1061,     75,  1061,     76,  1061,
     77,  1061,     78,  1061,     79,  1061,     80,  1061,     81,  1061,
     82,  1061,     83,  1061,     84,  1061,     85,  1061,     86,  1061,
     87,  1061,     88,  1061,     89,  1061,     90,  1061,     91,  1061,
     92,  1061,     93,  1061,     94,  1061,     95,  1061,     96,  1061,
     97,  1061,     98,  1061,     99,  1061,    100,  1061,    101,  1061,
    102,  1061,    103,  1061,    104,  1061,    105,  1061,    106,  1061,

    107,  1061,    108,  1061,    109,  1061,    110,  1061,    111,  1061,
    112,  1061,    113,  1061,    114,  1061,    115,  1061,    116,  1061,
    117,  1061,    118,  1061,    119,  1061,    120,  1061,    121,  1061,
    122,  1061,    123,  1061,    124,  1061,    125,  1061,    126,  1061,
    127,  1061,    128,  1061,    129,  1061,    130,  1061,    131,  1061,
    132,  1061,    133,  1061,    134,  1061,    135,  1061,    136,  1061,
    137,  1061,    138,  1061,    139,  1061,    140,  1061,    141,  1061,
    142,  1061,    143,  1061,    144,  1061,    145,  1061,    146,  1061,
    147,  1061,    148,  1061,    149,  1061,    150,  1061,    151,  1061,
    152,  1061,    153,  1061,    154,  1061,    155,  1061,    156,  1061,

    157,  1061,    158,  1061,    159,  1061,    160,  1061,    161,  1061,
    162,  1061,    163,  1061,    164,  1061,    165,  1061,    166,  1061,
    167,  1061,    168,  1061,    169,  1061,    170,  1061,    171,  1061,
    172,  1061,    173,  1061,    174,  1061,    175,  1061,    176,  1061,
    177,  1061,    178,  1061,    179,  1061,    180,  1061,    181,  1061,
    182,  1061,    183,  1061,    184,  1061,    185,  1061,    186,  1061,
    187,  1061,    188,  1061,    189,  1061,    190,  1061,    191,  1061,
    192,  1061,    193,  1061,    194,  1061,    195,  1061,    196,  1061,
    197,  1061,    198,  1061,    199,  1061,    200,  1061,    201,  1061,
    202,  1061,    203,  1061,    204,  1061,    205,  1061,    206,  1061,

    207,  1061,    208,  1061,    209,  1061,    210,  1061,    211,  1061,
    212,  1061,    213,  1061,    214,  1061,    215,  1061,    216,  1061,
    217,  1061,    218,  1061,    219,  1061,    220,  1061,    221,  1061,
    222,  1061,    223,  1061,    224,  1061,    225,  1061,    226,  1061,
    227,  1061,    228,  1061,    229,  1061,    230,  1061,    231,  1061,
    232,  1061,    233,  1061,    234,  1061,    235,  1061,    236,  1061,
    237,  1061,    238,  1061,    239,  1061,    240,  1061,    241,  1061,
    242,  1061,    243,  1061,    244,  1061,    245,  1061,    246,  1061,
    247,  1061,    248,  1061,    249,  1061,    250,  1061,    251,  1061,
    252,  1061,    253,  1061,    254,  1061,    255,  1061,    256,  1061,

      0,     2,      0,  1730,      1,   803,      2,   803,      3,   803,
      4,   803,      5,   803,      6,   803,      7,   803,      8,   803,
      9,  1061,     10,   645,     11,   803,     12,   803,     13,   803,
     14,   803,     15,   803,     16,   803,     17,   803,     18,   803,
     19,   803,     20,   803,     21,   803,     22,   803,     23,   803,
     24,   803,     25,   803,     26,   803,     27,   803,     28,   803,
     29,   803,     30,   803,     31,   803,     32,  1061,     33,   803,
     34,   803,     35,   803,     36,   803,     37,   803,     38,   803,
     39,   803,     40,   803,     41,   803,     42,   803,     43,   803,
     44,   803,     45,   803,     46,   803,     47,   803,     48,   803,

     49,   803,     50,   803,     51,   803,     52,   803,     53,   803,
     54,   803,     55,   803,     56,   803,     57,   803,     58,   803,
     59,   643,     60,   803,     61,   803,     62,   803,     63,   803,
     64,   803,     65,   803,     66,   803,     67,   803,     68,   803,
     69,   803,     70,   803,     71,   803,     72,   803,     73,   803,
     74,   803,     75,   803,     76,   803,     77,   803,     78,   803,
     79,   803,     80,   803,     81,   803,     82,   803,     83,   803,
     84,   803,     85,   803,     86,   803,     87,   803,     88,   803,
     89,   803,     90,   803,     91,   803,     92,   803,     93,   803,
     94,   803,     95,   803,     96,   803,     97,   803,     98,   803,

     99,   803,    100,   803,    101,   803,    102,   803,    103,   803,
    104,   803,    105,   803,    106,   803,    107,   803,    108,   803,
    109,   803,    110,   803,    111,   803,    112,   803,    113,   803,
    114,   803,    115,   803,    116,   803,    117,   803,    118,   803,
    119,   803,    120,   803,    121,   803,    122,   803,    123,   803,
    124,   803,    125,   803,    126,   803,    127,   803,    128,   803,
    129,   803,    130,   803,    131,   803,    132,   803,    133,   803,
    134,   803,    135,   803,    136,   803,    137,   803,    138,   803,
    139,   803,    140,   803,    141,   803,    142,   803,    143,   803,
    144,   803,    145,   803,    146,   803,    147,   803,    148,   803,

    149,   803,    150,   803,    151,   803,    152,   803,    153,   803,
    154,   803,    155,   803,    156,   803,    157,   803,    158,   803,
    159,   803,    160,   803,    161,   803,    162,   803,    163,   803,
    164,   803,    165,   803,    166,   803,    167,   803,    168,   803,
    169,   803,    170,   803,    171,   803,    172,   803,    173,   803,
    174,   803,    175,   803,    176,   803,    177,   803,    178,   803,
    179,   803,    180,   803,    181,   803,    182,   803,    183,   803,
    184,   803,    185,   803,    186,   803,    187,   803,    188,   803,
    189,   803,    190,   803,    191,   803,    192,   803,    193,   803,
    194,   803,    195,   803,    196,   803,    197,   803,    198,   803,

    199,   803,    200,   803,    201,   803,    202,   803,    203,   803,
    204,   803,    205,   803,    206,   803,    207,   803,    208,   803,
    209,   803,    210,   803,    211,   803,    212,   803,    213,   803,
    214,   803,    215,   803,    216,   803,    217,   803,    218,   803,
    219,   803,    220,   803,    221,   803,    222,   803,    223,   803,
    224,   803,    225,   803,    226,   803,    227,   803,    228,   803,
    229,   803,    230,   803,    231,   803,    232,   803,    233,   803,
    234,   803,    235,   803,    236,   803,    237,   803,    238,   803,
    239,   803,    240,   803,    241,   803,    242,   803,    243,   803,
    244,   803,    245,   803,    246,   803,    247,   803,    248,   803,

    249,   803,    250,   803,    251,   803,    252,   803,    253,   803,
    254,   803,    255,   803,    256,   803,      0,    34,      0,  1472,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,  1459,      0,     0,      0,     0,
      0,     0,      0,     0,      0,    35,      0,  1453,      0,     6,
      0,  1451,      0,    10,      0,  1449,      0,    11,      0,  1447,
      0,    19,      0,  1445,      0,    33,      0,  1443,      0,    23,
      0,  1441,      0,    26,      0,  1439,      0,    31,      0,  1437,
     36,     0,      0,    27,      0,  1434,      0,     0,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,     48,     0,     49,     0,     50,     0,
     51,     0,     52,     0,     53,     0,     54,     0,     55,     0,
     56,     0,     57,     0,     39,   106,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,     65,     0,
     66,     0,     67,     0,     68,     0,     69,     0,     70,     0,
     71,     0,     72,     0,     73,     0,     74,     0,     75,     0,
     76,     0,     77,     0,     78,     0,     79,     0,     80,     0,
     81,     0,     82,     0,     83,     0,     84,     0,     85,     0,
     86,     0,     87,     0,     88,     0,     89,     0,     90,     0,

     78,   388,      0,     0,      0,     0,      0,     0,     95,     0,
      0,     0,     97,     0,     98,     0,     99,     0,    100,     0,
    101,     0,    102,     0,    103,     0,    104,     0,    105,     0,
    106,     0,    107,     0,    108,     0,    109,     0,    110,     0,
    111,     0,    112,     0,    113,     0,    114,     0,    115,     0,
    116,     0,    117,     0,    118,     0,    119,     0,    120,     0,
    121,     0,    122,     0,    110,   388,      0,     0,      0,  1347,
      1,     0,      2,     0,      3,     0,      4,     0,      5,     0,
      6,     0,      7,     0,      8,     0,      9,     0,     10,     0,
     11,     0,     12,     0,     13,     0,     14,     0,     15,     0,

     16,     0,     17,     0,     18,     0,     19,     0,     20,     0,
     21,     0,     22,     0,     23,     0,     24,     0,     25,     0,
     26,     0,     27,     0,     28,     0,     29,     0,     30,     0,
     31,     0,     32,     0,     33,     0,     34,     0,     35,     0,
     36,     0,     37,     0,     38,     0,     39,  -106,     40,     0,
     41,     0,     42,     0,     43,     0,     44,     0,     45,     0,
     46,     0,     47,     0,     48,     0,     49,     0,     50,     0,
     51,     0,     52,     0,     53,     0,     54,     0,     55,     0,
     56,     0,     57,     0,     58,     0,     59,     0,     60,     0,
     61,     0,     62,     0,     63,     0,     64,     0,     65,     0,

     66,     0,     67,     0,     68,     0,     69,     0,     70,     0,
     71,     0,     72,     0,     73,     0,     74,     0,     75,     0,
     76,     0,     77,     0,     78,     0,     79,     0,     80,     0,
     81,     0,     82,     0,     83,     0,     84,     0,     85,     0,
     86,     0,     87,     0,     88,     0,     89,     0,     90,     0,
     91,     0,     92,     0,     93,     0,     94,     0,     95,     0,
     96,     0,     97,     0,     98,     0,     99,     0,    100,     0,
    101,     0,    102,     0,    103,     0,    104,     0,    105,     0,
    106,     0,    107,     0,    108,     0,    109,     0,    110,     0,
    111,     0,    112,     0,    113,     0,    114,     0,    115,     0,

    116,     0,    117,     0,    118,     0,    119,     0,    120,     0,
    121,     0,    122,     0,    123,     0,    124,     0,    125,     0,
    126,     0,    127,     0,    128,     0,    129,     0,    130,     0,
    131,     0,    132,     0,    133,     0,    134,     0,    135,     0,
    136,     0,    137,     0,    138,     0,    139,     0,    140,     0,
    141,     0,    142,     0,    143,     0,    144,     0,    145,     0,
    146,     0,    147,     0,    148,     0,    149,     0,    150,     0,
    151,     0,    152,     0,    153,     0,    154,     0,    155,     0,
    156,     0,    157,     0,    158,     0,    159,     0,    160,     0,
    161,     0,    162,     0,    163,     0,    164,     0,    165,     0,

    166,     0,    167,     0,    168,     0,    169,     0,    170,     0,
    171,     0,    172,     0,    173,     0,    174,     0,    175,     0,
    176,     0,    177,     0,    178,     0,    179,     0,    180,     0,
    181,     0,    182,     0,    183,     0,    184,     0,    185,     0,
    186,     0,    187,     0,    188,     0,    189,     0,    190,     0,
    191,     0,    192,     0,    193,     0,    194,     0,    195,     0,
    196,     0,    197,     0,    198,     0,    199,     0,    200,     0,
    201,     0,    202,     0,    203,     0,    204,     0,    205,     0,
    206,     0,    207,     0,    208,     0,    209,     0,    210,     0,
    211,     0,    212,     0,    213,     0,    214,     0,    215,     0,

    216,     0,    217,     0,    218,     0,    219,     0,    220,     0,
    221,     0,    222,     0,    223,     0,    224,     0,    225,     0,
    226,     0,    227,     0,    228,     0,    229,     0,    230,     0,
    231,     0,    232,     0,    233,     0,    234,     0,    235,     0,
    236,     0,    237,     0,    238,     0,    239,     0,    240,     0,
    241,     0,    242,     0,    243,     0,    244,     0,    245,     0,
    246,     0,    247,     0,    248,     0,    249,     0,    250,     0,
    251,     0,    252,     0,    253,     0,    254,     0,    255,     0,
    256,     0,      0,     0,      0,  1089,      0,     3,      0,  1087,
      0,     2,      0,  1085,      0,     0,      0,     0,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      9,     0,     10,     0,      0,     0,      0,     0,      0,     0,
      0,  1071,      0,     0,      0,     0,      0,     0,      0,     0,
      0,  1066,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,     32,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,  1047,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
     48,   678,     49,   678,     50,   678,     51,   678,     52,   678,
     53,   678,     54,   678,     55,   678,     56,   678,     57,   678,

      0,    33,      0,  1030,      0,     0,     59,     0,      0,     0,
      0,     0,      0,     0,     65,   678,     66,   678,     67,   678,
     68,   678,     69,   678,     70,   678,     48,   678,     49,   678,
     50,   678,     51,   678,     52,   678,     53,   678,     54,   678,
     55,   678,     56,   678,     57,   678,      0,     0,      0,     0,
      0,     0,      0,  1005,     67,    24,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,     35,   -59,      0,     0,      0,     0,     97,   678,
     98,   678,     99,   678,    100,   678,    101,   678,    102,   678,
      0,     0,      0,     0,     46,   -36,      0,     0,     48,   678,

     49,   678,     50,   678,     51,   678,     52,   678,     53,   678,
     54,   678,     55,   678,     56,   678,     57,   678,     99,    24,
     76,   638,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,     66,  -413,      0,     0,     43,   676,
     69,    25,     45,   676,      0,     0,      0,     0,     48,   688,
     49,   688,     50,   688,     51,   688,     52,   688,     53,   688,
     54,   688,     55,   688,     56,   688,     57,   688,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,    108,   638,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,     98,  -413,

      0,     0,      0,     0,    101,    25,      0,     3,      0,   927,
      1,     0,      2,     0,      3,     0,      4,     0,      5,     0,
      6,     0,      7,     0,      8,     0,      9,     0,      0,     0,
     11,     0,     12,     0,     13,     0,     14,     0,     15,     0,
     16,     0,     17,     0,     18,     0,     19,     0,     20,     0,
     21,     0,     22,     0,     23,     0,     24,     0,     25,     0,
     26,     0,     27,     0,     28,     0,     29,     0,     30,     0,
     31,     0,     32,     0,     33,     0,     34,     0,     35,     0,
     36,     0,     37,     0,     38,     0,     39,     0,     40,     0,
     41,     0,     42,     0,     43,     0,     44,     0,     45,     0,

     46,     0,     47,     0,     48,     0,     49,     0,     50,     0,
     51,     0,     52,     0,     53,     0,     54,     0,     55,     0,
     56,     0,     57,     0,     58,     0,     59,  -160,     60,     0,
     61,     0,     62,     0,     63,     0,     64,     0,     65,     0,
     66,     0,     67,     0,     68,     0,     69,     0,     70,     0,
     71,     0,     72,     0,     73,     0,     74,     0,     75,     0,
     76,     0,     77,     0,     78,     0,     79,     0,     80,     0,
     81,     0,     82,     0,     83,     0,     84,     0,     85,     0,
     86,     0,     87,     0,     88,     0,     89,     0,     90,     0,
     91,     0,     92,     0,     93,     0,     94,     0,     95,     0,

     96,     0,     97,     0,     98,     0,     99,     0,    100,     0,
    101,     0,    102,     0,    103,     0,    104,     0,    105,     0,
    106,     0,    107,     0,    108,     0,    109,     0,    110,     0,
    111,     0,    112,     0,    113,     0,    114,     0,    115,     0,
    116,     0,    117,     0,    118,     0,    119,     0,    120,     0,
    121,     0,    122,     0,    123,     0,    124,     0,    125,     0,
    126,     0,    127,     0,    128,     0,    129,     0,    130,     0,
    131,     0,    132,     0,    133,     0,    134,     0,    135,     0,
    136,     0,    137,     0,    138,     0,    139,     0,    140,     0,
    141,     0,    142,     0,    143,     0,    144,     0,    145,     0,

    146,     0,    147,     0,    148,     0,    149,     0,    150,     0,
    151,     0,    152,     0,    153,     0,    154,     0,    155,     0,
    156,     0,    157,     0,    158,     0,    159,     0,    160,     0,
    161,     0,    162,     0,    163,     0,    164,     0,    165,     0,
    166,     0,    167,     0,    168,     0,    169,     0,    170,     0,
    171,     0,    172,     0,    173,     0,    174,     0,    175,     0,
    176,     0,    177,     0,    178,     0,    179,     0,    180,     0,
    181,     0,    182,     0,    183,     0,    184,     0,    185,     0,
    186,     0,    187,     0,    188,     0,    189,     0,    190,     0,
    191,     0,    192,     0,    193,     0,    194,     0,    195,     0,

    196,     0,    197,     0,    198,     0,    199,     0,    200,     0,
    201,     0,    202,     0,    203,     0,    204,     0,    205,     0,
    206,     0,    207,     0,    208,     0,    209,     0,    210,     0,
    211,     0,    212,     0,    213,     0,    214,     0,    215,     0,
    216,     0,    217,     0,    218,     0,    219,     0,    220,     0,
    221,     0,    222,     0,    223,     0,    224,     0,    225,     0,
    226,     0,    227,     0,    228,     0,    229,     0,    230,     0,
    231,     0,    232,     0,    233,     0,    234,     0,    235,     0,
    236,     0,    237,     0,    238,     0,    239,     0,    240,     0,
    241,     0,    242,     0,    243,     0,    244,     0,    245,     0,

    246,     0,    247,     0,    248,     0,    249,     0,    250,     0,
    251,     0,    252,     0,    253,     0,    254,     0,    255,     0,
    256,     0,      0,     2,      0,   669,      1,  -258,      2,  -258,
      3,  -258,      4,  -258,      5,  -258,      6,  -258,      7,  -258,
      8,  -258,      9,     0,     10,  -416,     11,  -258,     12,  -258,
     13,  -258,     14,  -258,     15,  -258,     16,  -258,     17,  -258,
     18,  -258,     19,  -258,     20,  -258,     21,  -258,     22,  -258,
     23,  -258,     24,  -258,     25,  -258,     26,  -258,     27,  -258,
     28,  -258,     29,  -258,     30,  -258,     31,  -258,     32,     0,
     33,  -258,     34,  -258,     35,  -258,     36,  -258,     37,  -258,

     38,  -258,     39,  -258,     40,  -258,     41,  -258,     42,  -258,
     43,  -258,     44,  -258,     45,  -258,     46,  -258,     47,  -258,
     48,  -258,     49,  -258,     50,  -258,     51,  -258,     52,  -258,
     53,  -258,     54,  -258,     55,  -258,     56,  -258,     57,  -258,
     58,  -258,     59,  -418,     60,  -258,     61,  -258,     62,  -258,
     63,  -258,     64,  -258,     65,  -258,     66,  -258,     67,  -258,
     68,  -258,     69,  -258,     70,  -258,     71,  -258,     72,  -258,
     73,  -258,     74,  -258,     75,  -258,     76,  -258,     77,  -258,
     78,  -258,     79,  -258,     80,  -258,     81,  -258,     82,  -258,
     83,  -258,     84,  -258,     85,  -258,     86,  -258,     87,  -258,

     88,  -258,     89,  -258,     90,  -258,     91,  -258,     92,  -258,
     93,  -258,     94,  -258,     95,  -258,     96,  -258,     97,  -258,
     98,  -258,     99,  -258,    100,  -258,    101,  -258,    102,  -258,
    103,  -258,    104,  -258,    105,  -258,    106,  -258,    107,  -258,
    108,  -258,    109,  -258,    110,  -258,    111,  -258,    112,  -258,
    113,  -258,    114,  -258,    115,  -258,    116,  -258,    117,  -258,
    118,  -258,    119,  -258,    120,  -258,    121,  -258,    122,  -258,
    123,  -258,    124,  -258,    125,  -258,    126,  -258,    127,  -258,
    128,  -258,    129,  -258,    130,  -258,    131,  -258,    132,  -258,
    133,  -258,    134,  -258,    135,  -258,    136,  -258,    137,  -258,

    138,  -258,    139,  -258,    140,  -258,    141,  -258,    142,  -258,
    143,  -258,    144,  -258,    145,  -258,    146,  -258,    147,  -258,
    148,  -258,    149,  -258,    150,  -258,    151,  -258,    152,  -258,
    153,  -258,    154,  -258,    155,  -258,    156,  -258,    157,  -258,
    158,  -258,    159,  -258,    160,  -258,    161,  -258,    162,  -258,
    163,  -258,    164,  -258,    165,  -258,    166,  -258,    167,  -258,
    168,  -258,    169,  -258,    170,  -258,    171,  -258,    172,  -258,
    173,  -258,    174,  -258,    175,  -258,    176,  -258,    177,  -258,
    178,  -258,    179,  -258,    180,  -258,    181,  -258,    182,  -258,
    183,  -258,    184,  -258,    185,  -258,    186,  -258,    187,  -258,

    188,  -258,    189,  -258,    190,  -258,    191,  -258,    192,  -258,
    193,  -258,    194,  -258,    195,  -258,    196,  -258,    197,  -258,
    198,  -258,    199,  -258,    200,  -258,    201,  -258,    202,  -258,
    203,  -258,    204,  -258,    205,  -258,    206,  -258,    207,  -258,
    208,  -258,    209,  -258,    210,  -258,    211,  -258,    212,  -258,
    213,  -258,    214,  -258,    215,  -258,    216,  -258,    217,  -258,
    218,  -258,    219,  -258,    220,  -258,    221,  -258,    222,  -258,
    223,  -258,    224,  -258,    225,  -258,    226,  -258,    227,  -258,
    228,  -258,    229,  -258,    230,  -258,    231,  -258,    232,  -258,
    233,  -258,    234,  -258,    235,  -258,    236,  -258,    237,  -258,

    238,  -258,    239,  -258,    240,  -258,    241,  -258,    242,  -258,
    243,  -258,    244,  -258,    245,  -258,    246,  -258,    247,  -258,
    248,  -258,    249,  -258,    250,  -258,    251,  -258,    252,  -258,
    253,  -258,    254,  -258,    255,  -258,    256,  -258,      0,    33,
      0,   411,      0,     0,      0,   409,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,   391,      0,     0,      0,    32,      0,   388,      0,     0,
      0,     0,      0,   385,      0,     1,      0,   383,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,     48,     0,     49,     0,
     50,     0,     51,     0,     52,     0,     53,     0,     54,     0,
     55,     0,     56,     0,     57,     0,      0,    33,      0,   352,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
     65,     0,     66,     0,     67,     0,     68,     0,     69,     0,
     70,     0,     48,     0,     49,     0,     50,     0,     51,     0,
     52,     0,     53,     0,     54,     0,     55,     0,     56,     0,

     57,     0,      0,     0,      0,   329,      0,     0,      0,     0,
      0,     0,      0,     0,     85,    18,     68,     6,      0,     0,
      0,     0,      0,     0,     69,    95,      0,    32,      0,   317,
     69,     2,      0,     0,     97,     0,     98,     0,     99,     0,
    100,     0,    101,     0,    102,     0,      0,     0,      0,     0,
     46,  -714,      0,     0,     48,     0,     49,     0,     50,     0,
     51,     0,     52,     0,     53,     0,     54,     0,     55,     0,
     56,     0,     57,     0,      0,     0,      0,   293,    117,    18,
    100,     6,      0,     0,      0,     0,      0,     0,    101,    95,
     66, -1091,      0,     0,    101,     2,     69,  -653,      0,     0,

     48,    12,     49,    12,     50,    12,     51,    12,     52,    12,
     53,    12,     54,    12,     55,    12,     56,    12,     57,    12,
      0,     0,      0,   270,     48,     0,     49,     0,     50,     0,
     51,     0,     52,     0,     53,     0,     54,     0,     55,     0,
     56,     0,     57,     0,      0,    32,      0,   258,      0,     0,
      0,     0,      0,     0,     98, -1091,      0,     0,      0,     0,
    101,  -653,     43,    23,      0,     0,     45,    23,      0,     0,
      0,     0,     48,    35,     49,    35,     50,    35,     51,    35,
     52,    35,     53,    35,     54,    35,     55,    35,     56,    35,
     57,    35,      0,     0,      0,     0,      0,     0,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,     48,    12,
     49,    12,     50,    12,     51,    12,     52,    12,     53,    12,
     54,    12,     55,    12,     56,    12,     57,    12,      0,     0,
      0,     0,     48,     0,     49,     0,     50,     0,     51,     0,
     52,     0,     53,     0,     54,     0,     55,     0,     56,     0,
     57,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,

      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
      0,     0,      0,     0,      0,     0,      0,     0,      0,     0,
    257,    40,      1,     0,    };

static const struct yy_trans_info *yy_start_state_list[5] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],


    } ;

static yy_state_type yy_last_accepting_state;
static YY_CHAR *yy_last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static YY_CHAR *yy_c_buf_p = (YY_CHAR *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yyunput YY_PROTO(( YY_CHAR c, YY_CHAR *buf_ptr ));
void yyrestart YY_PROTO(( FILE *input_file ));
void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));

#define yy_new_buffer yy_create_buffer

#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif

YY_DECL
    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp, *yy_bp;
    register int yy_act;



    if ( yy_init )
	{
	YY_USER_INIT;

	if ( ! yy_start )
	    yy_start = 1;	/* first start state */

	if ( ! yyin )
	    yyin = stdin;

	if ( ! yyout )
	    yyout = stdout;

	if ( yy_current_buffer )
	    yy_init_buffer( yy_current_buffer, yyin );
	else
	    yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_load_buffer_state();

	yy_init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	yy_cp = yy_c_buf_p;

	/* support of yytext */
	*yy_cp = yy_hold_char;

	/* yy_bp points to the position in yy_ch_buf of the start of the
	 * current run.
	 */
	yy_bp = yy_cp;

	yy_current_state = yy_start_state_list[yy_start];
yy_match:
	{
	register const struct yy_trans_info *yy_trans_info;

	register YY_CHAR yy_c;

	for ( yy_c = *yy_cp;
	      (yy_trans_info = &yy_current_state[yy_c])->yy_verify == yy_c;
	      yy_c = *++yy_cp )
	    {
	    yy_current_state += yy_trans_info->yy_nxt;

	    if ( yy_current_state[-1].yy_nxt )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	    }
	}

yy_find_action:
	yy_act = yy_current_state[-1].yy_nxt;

	YY_DO_BEFORE_ACTION;
	YY_USER_ACTION;

do_action:	/* this label is used only to access EOF actions */


	switch ( yy_act )
	    {
	    case 0: /* must backtrack */
	    /* undo the effects of YY_DO_BEFORE_ACTION */
	    *yy_cp = yy_hold_char;
	    yy_cp = yy_last_accepting_cpos + 1;
	    yy_current_state = yy_last_accepting_state;
	    goto yy_find_action;

case 1:
# line 200 "lex.l"
BEGIN(incl);
	YY_BREAK
case 2:
# line 203 "lex.l"
{  /* eat the whitespace */
    char* p = yytext; 
    while(*p != '\0') { 
	if (*p++ == '\n') line += 1; 
    } 
}
	YY_BREAK
case 3:
# line 209 "lex.l"
{ 
                  /* got the include file name */
    BEGIN(INITIAL);     // To leave include state
    
    char *fname = include_name (yytext);
    char *xname;
    FILE *in = NULL;
    char *try_dir, *next_dir;
    int dir_length;
    
    for (try_dir = i_path; try_dir != NULL; try_dir = next_dir) {
	if ((next_dir = strchr (try_dir, ':')) != NULL ) {
	    dir_length = next_dir - try_dir;
	    next_dir++; 
	} else {
	    dir_length = strlen (try_dir);
	}
	xname = dprintf ("%.*s/%s", dir_length, try_dir, fname);
	if ((in = fopen(xname, "r")) != NULL) {
	    scanner.push();
	    scanner.attach(xname, in);
	    curr_token = new token(xname, TKN_PUSH_FILE);
	    curr_token->out_text = fname; 
	    return 1;
	}
    }
    warning(line, pos, file_name, "can't include file %s", fname);
    curr_token = new token(dprintf("/*#include \"%s\"*/", fname),
	                   TKN_CMNT, line, pos);
    return 1;
}
	YY_BREAK
case 4:
# line 240 "lex.l"
{ 
    error(line, pos, file_name, "unrecognized tocken: %s\n",
		yytext); 
}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(incl):
# line 246 "lex.l"
{
    if (scanner.empty()) { 
	return -1;  // MAGIC ! (< 0 means end of files)
    } else {
	scanner.pop();
	curr_token =  new token((char*)NULL, TKN_POP_FILE);
	return 1;
    }
}
	YY_BREAK
case 6:
# line 256 "lex.l"
{ return process_comments(); }
	YY_BREAK
case 7:
# line 257 "lex.l"
{ return process_comments(); }
	YY_BREAK
case 8:
# line 259 "lex.l"
{ return tkn(TKN_LPAR); }
	YY_BREAK
case 9:
# line 260 "lex.l"
{ return tkn(TKN_RPAR); }
	YY_BREAK
case 10:
# line 261 "lex.l"
{ text = "["; return tkn(TKN_LBR);  }
	YY_BREAK
case 11:
# line 262 "lex.l"
{ text = "]"; return tkn(TKN_RBR);  }
	YY_BREAK
case 12:
# line 263 "lex.l"
{ return tkn(TKN_LBR);  }
	YY_BREAK
case 13:
# line 264 "lex.l"
{ return tkn(TKN_RBR);  }
	YY_BREAK
case 14:
# line 265 "lex.l"
{ return tkn(TKN_MUL);  }
	YY_BREAK
case 15:
# line 266 "lex.l"
{ return tkn(TKN_PLUS); }
	YY_BREAK
case 16:
# line 267 "lex.l"
{ return tkn(TKN_MINUS);}
	YY_BREAK
case 17:
# line 268 "lex.l"
{ return tkn(TKN_COMMA);}
	YY_BREAK
case 18:
# line 269 "lex.l"
{ return tkn(TKN_DOT);  }
	YY_BREAK
case 19:
# line 270 "lex.l"
{ return tkn(TKN_DOTS); }
	YY_BREAK
case 20:
# line 271 "lex.l"
{ return tkn(TKN_DIVR);  }
	YY_BREAK
case 21:
# line 272 "lex.l"
{ return tkn(TKN_HEAP); }
	YY_BREAK
case 22:
# line 273 "lex.l"
{ return tkn(TKN_HEAP); }
	YY_BREAK
case 23:
# line 274 "lex.l"
{ return tkn(TKN_LET);  }
	YY_BREAK
case 24:
# line 275 "lex.l"
{ return tkn(TKN_COLON);}
	YY_BREAK
case 25:
# line 276 "lex.l"
{ return tkn(TKN_SEMICOLON); }
	YY_BREAK
case 26:
# line 277 "lex.l"
{ return tkn(TKN_LE);  }
	YY_BREAK
case 27:
# line 278 "lex.l"
{ return tkn(TKN_GE);  }
	YY_BREAK
case 28:
# line 279 "lex.l"
{ return tkn(TKN_LT);  }
	YY_BREAK
case 29:
# line 280 "lex.l"
{ return tkn(TKN_GT);  }
	YY_BREAK
case 30:
# line 281 "lex.l"
{ return tkn(TKN_EQ);  }
	YY_BREAK
case 31:
# line 282 "lex.l"
{ return tkn(TKN_NE);  }
	YY_BREAK
case 32:
# line 285 "lex.l"
{ return tkn(TKN_RCONST); }
	YY_BREAK
case 33:
# line 286 "lex.l"
{ return tkn(TKN_ICONST);  } 
	YY_BREAK
case 34:
# line 288 "lex.l"
{ 
	       char *p = yytext; 
	       while (*p) { *p = tolower(*p); p += 1; }

               nm = nm_entry::add(yytext, TKN_IDENT); 
	       int tag = nm->tag;

	       if (tag == TKN_RESERVED) { 
	           text = dprintf("%s_", yytext);      
		   nm = nm_entry::add(text, TKN_IDENT); 
		   tag = TKN_IDENT;
               }
	       return tkn(tag);
             }  
	YY_BREAK
case 35:
# line 304 "lex.l"
{ return tkn(TKN_SCONST); }  
	YY_BREAK
case 36:
# line 306 "lex.l"
{ return tkn(TKN_SPACE); }   
	YY_BREAK
case 37:
# line 308 "lex.l"
{ return tkn(TKN_LN); } 
	YY_BREAK
case 38:
# line 310 "lex.l"
{ 
                error(line, pos, file_name, "unrecognized tocken: %s\n",
		      yytext); 
             }
	YY_BREAK
case 39:
# line 315 "lex.l"
ECHO;
	YY_BREAK

	    case YY_END_OF_BUFFER:
		{
		/* amount of text matched not including the EOB char */
		int yy_amount_of_matched_text = yy_cp - (unsigned char *)yytext - 1;

		/* undo the effects of YY_DO_BEFORE_ACTION */
		*yy_cp = yy_hold_char;

		/* note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the end-
		 * of-buffer state).  Contrast this with the test in yyinput().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
		    /* this was really a NUL */
		    {
		    yy_state_type yy_next_state;

		    yy_c_buf_p = (unsigned char *)yytext + yy_amount_of_matched_text;

		    yy_current_state = yy_get_previous_state();

		    /* okay, we're now positioned to make the
		     * NUL transition.  We couldn't have
		     * yy_get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we
		     * don't want to build jamming into it because
		     * then it will run more slowly)
		     */

		    yy_next_state = yy_try_NUL_trans( yy_current_state );

		    yy_bp = (unsigned char *)yytext + YY_MORE_ADJ;

		    if ( yy_next_state )
			{
			/* consume the NUL */
			yy_cp = ++yy_c_buf_p;
			yy_current_state = yy_next_state;
			goto yy_match;
			}

		    else
			{
			    yy_cp = yy_c_buf_p;
			goto yy_find_action;
			}
		    }

		else switch ( yy_get_next_buffer() )
		    {
		    case EOB_ACT_END_OF_FILE:
			{
			yy_did_buffer_switch_on_eof = 0;

			if ( yywrap() )
			    {
			    /* note: because we've taken care in
			     * yy_get_next_buffer() to have set up yytext,
			     * we can now set up yy_c_buf_p so that if some
			     * total hoser (like flex itself) wants
			     * to call the scanner after we return the
			     * YY_NULL, it'll still work - another YY_NULL
			     * will get returned.
			     */
			    yy_c_buf_p = (unsigned char *)yytext + YY_MORE_ADJ;

			    yy_act = YY_STATE_EOF((yy_start - 1) / 2);
			    goto do_action;
			    }

			else
			    {
			    if ( ! yy_did_buffer_switch_on_eof )
				YY_NEW_FILE;
			    }
			}
			break;

		    case EOB_ACT_CONTINUE_SCAN:
			yy_c_buf_p = (unsigned char *)yytext + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = (unsigned char *)yytext + YY_MORE_ADJ;
			goto yy_match;

		    case EOB_ACT_LAST_MATCH:
			yy_c_buf_p =
			    &yy_current_buffer->yy_ch_buf[yy_n_chars];

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = (unsigned char *)yytext + YY_MORE_ADJ;
			goto yy_find_action;
		    }
		break;
		}

	    default:
#ifdef FLEX_DEBUG
		printf( "action # %d\n", yy_act );
#endif
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	    }
	}
    }


/* yy_get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int yy_get_next_buffer();
 *     
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH - 
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()

    {
    register YY_CHAR *dest = yy_current_buffer->yy_ch_buf;
    register YY_CHAR *source = (unsigned char *)yytext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
	YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = yy_c_buf_p - (unsigned char *)yytext;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( yy_current_buffer->yy_eof_status != EOF_NOT_SEEN )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	yy_n_chars = 0;

    else
	{
	int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

	if ( num_to_read > YY_READ_BUF_SIZE )
	    num_to_read = YY_READ_BUF_SIZE;

	else if ( num_to_read <= 0 )
	    YY_FATAL_ERROR( "fatal error - scanner input buffer overflow" );

	/* read in more data */
	YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
		  yy_n_chars, num_to_read );
	}

    if ( yy_n_chars == 0 )
	{
	if ( number_to_move == 1 )
	    {
	    ret_val = EOB_ACT_END_OF_FILE;
	    yy_current_buffer->yy_eof_status = EOF_DONE;
	    }

	else
	    {
	    ret_val = EOB_ACT_LAST_MATCH;
	    yy_current_buffer->yy_eof_status = EOF_PENDING;
	    }
	}

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    yy_n_chars += number_to_move;
    yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
    yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* yytext begins at the second character in yy_ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * yy_get_previous_state() will have with '^' rules active
     */

    yytext = (char *) &yy_current_buffer->yy_ch_buf[1];

    return ( ret_val );
    }


/* yy_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     yy_state_type yy_get_previous_state();
 */

static yy_state_type yy_get_previous_state()

    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp;

    yy_current_state = yy_start_state_list[yy_start];

    for ( yy_cp = (unsigned char *)yytext + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
	{
	yy_current_state += yy_current_state[(*yy_cp ? *yy_cp : 256)].yy_nxt;
	if ( yy_current_state[-1].yy_nxt )
	    {
	    yy_last_accepting_state = yy_current_state;
	    yy_last_accepting_cpos = yy_cp;
	    }
	}

    return ( yy_current_state );
    }


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( register yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
register yy_state_type yy_current_state;
#endif

    {
    register int yy_is_jam;
    register YY_CHAR *yy_cp = yy_c_buf_p;

    register int yy_c = 256;
    register const struct yy_trans_info *yy_trans_info;

    yy_trans_info = &yy_current_state[yy_c];
    yy_current_state += yy_trans_info->yy_nxt;
    yy_is_jam = (yy_trans_info->yy_verify != yy_c);

    if ( ! yy_is_jam )
	{
	if ( yy_current_state[-1].yy_nxt )
	    {
	    yy_last_accepting_state = yy_current_state;
	    yy_last_accepting_cpos = yy_cp;
	    }
	}

    return ( yy_is_jam ? 0 : yy_current_state );
    }


#ifdef YY_USE_PROTOS
static void yyunput( YY_CHAR c, register YY_CHAR *yy_bp )
#else
static void yyunput( c, yy_bp )
YY_CHAR c;
register YY_CHAR *yy_bp;
#endif

    {
    register YY_CHAR *yy_cp = yy_c_buf_p;

    /* undo effects of setting up yytext */
    *yy_cp = yy_hold_char;

    if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = yy_n_chars + 2; /* +2 for EOB chars */
	register YY_CHAR *dest =
	    &yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
	register YY_CHAR *source =
	    &yy_current_buffer->yy_ch_buf[number_to_move];

	while ( source > yy_current_buffer->yy_ch_buf )
	    *--dest = *--source;

	yy_cp += dest - source;
	yy_bp += dest - source;
	yy_n_chars = yy_current_buffer->yy_buf_size;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	    YY_FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( yy_cp > yy_bp && yy_cp[-1] == '\n' )
	yy_cp[-2] = '\n';

    *--yy_cp = c;

    /* note: the formal parameter *must* be called "yy_bp" for this
     *       macro to now work correctly
     */
    YY_DO_BEFORE_ACTION; /* set up yytext again */
    }


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif

    {
    int c;
    YY_CHAR *yy_cp = yy_c_buf_p;

    *yy_cp = yy_hold_char;

    if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
	{
	/* yy_c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
	    /* this was really a NUL */
	    *yy_c_buf_p = '\0';

	else
	    { /* need more input */
	    yytext = (char *) yy_c_buf_p;
	    ++yy_c_buf_p;

	    switch ( yy_get_next_buffer() )
		{
		case EOB_ACT_END_OF_FILE:
		    {
		    if ( yywrap() )
			{
			yy_c_buf_p = (unsigned char *)yytext + YY_MORE_ADJ;
			return ( EOF );
			}

		    YY_NEW_FILE;

#ifdef __cplusplus
		    return ( yyinput() );
#else
		    return ( input() );
#endif
		    }
		    break;

		case EOB_ACT_CONTINUE_SCAN:
		    yy_c_buf_p = (unsigned char *)yytext + YY_MORE_ADJ;
		    break;

		case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
		    YY_FATAL_ERROR( "unexpected last match in yyinput()" );
#else
		    YY_FATAL_ERROR( "unexpected last match in input()" );
#endif
		}
	    }
	}

    c = *yy_c_buf_p;
    yy_hold_char = *++yy_c_buf_p;

    return ( c );
    }


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif

    {
    yy_init_buffer( yy_current_buffer, input_file );
    yy_load_buffer_state();
    }


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif

    {
    if ( yy_current_buffer == new_buffer )
	return;

    if ( yy_current_buffer )
	{
	/* flush out information for old buffer */
	*yy_c_buf_p = yy_hold_char;
	yy_current_buffer->yy_buf_pos = yy_c_buf_p;
	yy_current_buffer->yy_n_chars = yy_n_chars;
	}

    yy_current_buffer = new_buffer;
    yy_load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yy_did_buffer_switch_on_eof = 1;
    }


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif

    {
    yy_n_chars = yy_current_buffer->yy_n_chars;
    yytext = (char *) ( yy_c_buf_p = yy_current_buffer->yy_buf_pos);
    yyin = yy_current_buffer->yy_input_file;
    yy_hold_char = *yy_c_buf_p;
    }


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif

    {
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) malloc( sizeof( struct yy_buffer_state ) );

    if ( ! b )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (YY_CHAR *) malloc( (unsigned) (b->yy_buf_size + 2) );

    if ( ! b->yy_ch_buf )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    yy_init_buffer( b, file );

    return ( b );
    }


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif

    {
    if ( b == yy_current_buffer )
	yy_current_buffer = (YY_BUFFER_STATE) 0;

    free( (char *) b->yy_ch_buf );
    free( (char *) b );
    }


#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif

    {
    b->yy_input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->yy_ch_buf[0] = '\n';
    b->yy_n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[2] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[1];

    b->yy_eof_status = EOF_NOT_SEEN;
    }
# line 315 "lex.l"


void scan_ctx::push() { 
    assert(sp < MAX_INCLUDE_DEPTH);
    stack[sp].file_name = file_name;
    stack[sp].buffer = YY_CURRENT_BUFFER;
    stack[sp].search_path = i_path;
    stack[sp].pos = pos;
    stack[sp].line = line;
    stack[sp].input = yyin;
    sp += 1;
}


void scan_ctx::attach(char* name, FILE* in) { 
    pos = 0;
    line = 1;
    file_name = name;
    yyin = in;
    char* base_name = strrchr(name, '/');
    if (base_name != NULL) { 
	i_path = dprintf("%.*s:%s", base_name-name, name, i_path);
    }
    yy_switch_to_buffer(yy_create_buffer(yyin, YY_BUF_SIZE));
}

void scan_ctx::pop() { 
    assert(sp > 0);
    sp -= 1;
    pos = stack[sp].pos;
    line = stack[sp].line;
    file_name = stack[sp].file_name;
    yyin = stack[sp].input;
    i_path = stack[sp].search_path;
    yy_switch_to_buffer(stack[sp].buffer);
}

bool scan_ctx::find(char* name) { 
    for (int i = 0; i < sp; i ++ ) { 
	if (strcmp(stack[i].file_name, name) == 0) { 
	    return TRUE;
	}
    }
    return FALSE;
}

